#include <iostream>
#define N 200000
#define ll long long

using namespace std;

string a;
ll st[4*N];
bool lz[4*N];

void constr(int ind, int l, int d){
    if (l == d) {
        st[ind] = a[l] - '0';
        return;
    }
    constr(2*ind + 1, l, (l+d)/2);
    constr(2*ind + 2, (l+d)/2 + 1, d);
    st[ind] = st[2*ind+2] + st[2*ind+1];
}

void update(int ind, int l, int d, int koji, int vr){
    if (koji < l || koji > d) return;
    if (l == d) {
        if (st[ind] == 0)
        st[ind] = 1;
        else st[ind] = 0;
        return;
    }
    update(2*ind+1, l, (l+d)/2, koji, vr);
    update(2*ind+2, (l+d)/2+1, d, koji, vr);
    st[ind] = st[2*ind+2] + st[2*ind+1];
}

ll result (int ind, int l, int d, int trl, int trd){
    if (trl > d || l > trd) return 0;
    if (l == d) return st[ind];
    if (trl <= l && trd >= d) return st[ind];
    return result(2*ind+1, l, (l+d)/2, trl, trd) + result(2*ind+2, (l+d)/2+1, d, trl, trd);
}

void lzupdate(int ind, int l, int d, int tarl, int tard){
    if (l > tard || d < tarl) return;
    if (l >= tarl && d <= tard){
        st[ind] = (d-l+1) - st[ind];
        lz[ind] = !lz[ind];
    }
    else {
        if (lz[ind]){
        st[2*ind+1] = ((d+l)/2 - l + 1)- st[2*ind + 1];
        lz[2*ind+1] = !lz[2*ind+1];
        st[2*ind+2] = (d - (d+l)/2)- st[2*ind + 2];
        lz[2*ind+2] = !lz[2*ind+2];
        lz[ind] = !lz[ind];
        }
        lzupdate(ind*2+1, l, (l+d)/2, tarl, tard);
        lzupdate(ind*2+2, (l+d)/2+1, d, tarl, tard);
        st[ind] = st[2*ind+1] + st[2*ind+2];
    }
}

ll lzresult(int ind, int l, int d, int trl, int trd){
    if (trl > d || l > trd) return 0;
    if (trl <= l && trd >= d) return st[ind];
    if (lz[ind]){
        st[2*ind+1] = ((d+l)/2 - l + 1)- st[2*ind + 1];
        lz[2*ind+1] = !lz[2*ind+1];
        st[2*ind+2] = (d - (d+l)/2)- st[2*ind + 2];
        lz[2*ind+2] = !lz[2*ind+2];
        lz[ind] = !lz[ind];
    }
    return lzresult(2*ind+1, l, (l+d)/2, trl, trd) + lzresult(2*ind+2, (l+d)/2+1, d, trl, trd);
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    
    int n, c, q;
    cin >> n >> c >> q;
    cin >> a;
    if (c == n){
        constr(0, 0, n-1);
        while (q--){
            int l, r;
            cin >> l >> r;
            lzupdate(0, 0, n-1, l-1, r-1);
            cout << st[0] << endl;
        }
    }
    else if (c == 1){
        while (q--){
            int l, r;
            cin >> l >> r;
            l--;
            r--;
            for(int i = l; i <= r; ++i){
                if (a[i] == '0') a[i] = '1';
                else a[i] = '0';
            }
            int cnt = 0;
            for (int i = 1; i < n; ++i){
                if (a[i] != a[i-1]) ++cnt;
            }
            if (a[0] == a[n-1] == '1') cout << 1 + cnt/2 << endl;
            else if (a[0] == a[n-1] == '0') cout << cnt/2 << endl;
            else cout << cnt/2 + 1 << endl;
        }
    }
    return 0;
}